<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:ns="https://ezwm.nfz.gov.pl/xml/e-zpo/dok-zlecenia/v2.1" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- wersja transformaty -->
	<xsl:variable name="wersja" select="'1.1.0'"/>

	<xsl:output encoding="UTF-8" indent="yes" 
	doctype-public="-//W3C//DTD HTML 4.01//EN" 
	media-type="text/html"/>
	<xsl:include href="common.xslt"/>
	<xsl:template match="/ns:dokument-zpo">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"></meta>
				<xsl:call-template name="StyleWspolne"/>
				<style>
					@page {
					    size: A3;
					    margin-top: 0.5cm;
					    margin-left: 0cm;
					    margin-right: 0cm;
					}
				</style>
			</head>		
			<body>		
				<xsl:choose>
					<xsl:when test="./@typ-dokumentu != 'E'">
						<xsl:call-template name="bladTypDokumentu" />
					</xsl:when>
					<xsl:when test="./@nr-druku != 'Z.2023.1'">
						<xsl:call-template name="bladNrDruku" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="zlecenie">
							<xsl:with-param name="zlecenie" select="./ns:zlecenie" />
						</xsl:call-template>	
					</xsl:otherwise>
				</xsl:choose>
				<footer>
					<xsl:call-template name="footer">
						<xsl:with-param name="wersja" select="$wersja"/>
					</xsl:call-template>
				</footer>		
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="zlecenie">
		<xsl:param name="zlecenie"/>
		
		<div>

			<xsl:variable name="sposob-ordynacji" select="$zlecenie/ns:okreslenie-wyrob-med/ns:wyrob-med/ns:rodzaj-zaopatrzenia/ns:zaopatrzenie-comiesieczne/@sposob-ordynacji" />
					<div class="naglowek" align="center">
						<strong>ZLECENIE NA ZAOPATRZENIE W WYROBY MEDYCZNE</strong>
					</div>
					<div class="sekcja">
						<table class="tabela" border="0" style="height: 50px;">
							<tr>
								<td align="center" style="width: 35%; border-color: #FFFFFF;">
									<div align="left"
										style="font-size: 20px; font-weight: bold; vertical-align: text-top;">
										IDENTYFIKACJA ZLECENIA
									</div>
								</td>
								<td align="center" style="width: 65%; border-color: #FFFFFF;">
									<table class="rubryka" style="height: 50px;">
										<tr>
											<td style="width: 45%;">
												<input type="checkbox" disabled="disabled">
													<xsl:attribute name="readonly">readonly</xsl:attribute>
													<xsl:if test="$sposob-ordynacji != 'K' or not($sposob-ordynacji)">
														<xsl:attribute name="checked">checked</xsl:attribute>
													</xsl:if>											
													
												</input>
												<label>ZLECENIE</label>
											</td>
											<td style="width: 45%; vertical-align: middle;">
												<input type="checkbox" disabled="disabled">
													<xsl:attribute name="readonly">readonly</xsl:attribute>
													<xsl:if test="$sposob-ordynacji = 'K'">
														<xsl:attribute name="checked">checked</xsl:attribute>
													</xsl:if>																			
												</input>
												<label>KONTYNUACJA ZLECENIA</label><sup>1)</sup>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<xsl:call-template name="headerTable">
							<xsl:with-param name="zlecenie" select="$zlecenie"/>
						</xsl:call-template>
					</div>
					<div class="naglowek">
						<strong>CZĘŚĆ I. WYSTAWIENIE ZLECENIA </strong>
						<span style="font-size: 15px;">(WYPEŁNIA I DRUKUJE OSOBA UPRAWNIONA DO WYSTAWIENIA ZLECENIA)</span>
					</div>
					<xsl:variable name="miejsce" select="$zlecenie/ns:miejsce-wystawienia-zlecenia" />
					<div class="sekcja">
						<div><strong>I.A. DANE PODMIOTU, W RAMACH KTÓREGO WYSTAWIONO ZLECENIE</strong></div>
						<table class="rubryka" style="height: 90px;">
							<tr>
								<th style="width: 45%;">
									I.A.1 Nazwa	
								</th>
								<th style="width: 45%;">
									I.A.2 Adres miejsca udzielania świadczeń: kod pocztowy, miejscowość, ulica, numer domu lub lokalu		
									<sup>2)</sup>
								</th>
							</tr>
							<tr style="height: 70px;">
								<td class="left top">
									<xsl:value-of select="$miejsce/@nazwa" />
								</td>
								<td class="left top" rowspan="3">
									<xsl:variable name="adres" select="$miejsce/ns:adres" />
									<xsl:variable name="kod-kraju" select="$adres/@kod-kraju" />
										<xsl:choose>
											<xsl:when test="$kod-kraju">
												<xsl:value-of select="$kod-kraju" />
												<xsl:text> </xsl:text>
											</xsl:when>
											<xsl:when test="not($kod-kraju) and $adres and $adres/@miejscowosc">
												<xsl:text>PL </xsl:text>
											</xsl:when>
										</xsl:choose>		
										<xsl:value-of select="$adres/@kod-poczt"/><xsl:text> </xsl:text>
										<xsl:value-of select="$adres/@miejscowosc"/><xsl:text> </xsl:text>
										<xsl:value-of select="$adres/@ulica"/><xsl:text> </xsl:text>
										<xsl:value-of select="$adres/@nr-domu"/><xsl:text> </xsl:text>								
										<xsl:variable name="swd-nr-lokalu" select="$adres/@nr-lokalu" />									  
									    <xsl:if test="$swd-nr-lokalu">
									      <xsl:text> m. </xsl:text><xsl:value-of select="$swd-nr-lokalu"/>
										</xsl:if>
								</td>								
							</tr>
							<tr>
								<th style="width: 45%;">
									I.A.3 REGON<sup>3)</sup>
								</th>
							</tr>
							<tr style="height: 50px;">
								<td>
									<xsl:value-of select="$miejsce/@regon" />
								</td>							
							</tr>
						</table>
					</div>

					<xsl:variable name="pacjent" select="$zlecenie/ns:pacjent" />
					<xsl:variable name="typ-id" select="$pacjent/@typ-id-osoby" />
					<div class="sekcja">
						<div><strong>I.B. DANE PACJENTA</strong></div>
						<table class="rubryka" style="height: 90px;">
							<tr>
								<th style="width: 45%;" colspan="3">
									I.B.1 Imię (imiona)  
								</th>
								<th style="width: 45%;" colspan="3">
									I.B.2 Nazwisko		
								</th>
							</tr>
							<tr style="height: 35px;">
								<td class="left" colspan="3">
									<xsl:value-of select="$pacjent/@imie" />
								</td>
								<td class="left" colspan="3">								
									<xsl:value-of select="$pacjent/@nazwisko" />
								</td>								
							</tr>
							<tr colspan="3" style="height: 25px;">
								<th style="width: 15%;">
									I.B.3 Numer PESEL 
								</th>
								<th style="width: 15%;">
									I.B.4 Data urodzenia<sup>4)</sup> 	
								</th>
								<th style="width: 15%;">
									I.B.5 Płeć<sup>4)</sup> 
								</th>
								<th style="width: 15%;">
									I.B.6 Symbol państwa, jeżeli dotyczy<sup>5)</sup> 	
								</th>
								<th style="width: 40%;">
									I.B.7 Rodzaj i numer dokumentu uprawniającego do uzyskania przez pacjenta świadczeń opieki zdrowotnej, jeżeli dotyczy
									<sup>6)</sup>
								</th>
							</tr>
							<xsl:variable name="dokument" select="$pacjent/ns:potw-uprawnien/ns:dokument" />
							<xsl:variable name="dokument-ue" select="$dokument/ns:dokument-ue" />
							<tr style="height: 75px;">
								<td>
									<xsl:if test="$typ-id = 'P'">
										<xsl:value-of select="$pacjent/@id-osoby"/>
									</xsl:if>
								</td>
								<td>								
									<xsl:call-template name="dateFormat">
										<xsl:with-param name="data" select="$pacjent/@data-ur"/>
									</xsl:call-template>
								</td>	
								<td>
										<xsl:variable name="plec" select="$pacjent/@plec" />
										<xsl:choose>
											<xsl:when test="$plec='0'">
												nieznana
											</xsl:when>
											<xsl:when test="$plec='1'">
												mężczyzna
											</xsl:when>
											<xsl:when test="$plec='2'">
												kobieta
											</xsl:when>							
											<xsl:when test="$plec='9'">
												płeć nieokreślona
											</xsl:when>
										</xsl:choose>
								</td>
								<td>								
									<xsl:value-of select="$dokument-ue/@panstwo" />
								</td>
								<td>
									<xsl:value-of select="$dokument/@rodzaj"/>
									<xsl:if test="$dokument/@rodzaj">
										<xsl:call-template name="potwPrawaDokumentRodzaj">
											<xsl:with-param name="kodDok" select="$dokument/@rodzaj"/>
										</xsl:call-template>
									</xsl:if>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$dokument/@numer"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$dokument/@nazwa"/>
								</td>														
							</tr>
							<tr>
								<th style="width: 45%;" colspan="3">
									I.B.8 Rodzaj dokumentu stwierdzającego tożsamość<sup>4)</sup>
								</th>
								<th style="width: 45%;" colspan="3">
									I.B.9 Seria i numer<sup>4)</sup>		
								</th>
							</tr>
							<tr style="height: 50px;">
								<td class="left" colspan="3">
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$typ-id = 'T'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>											
											
										</input>
										<label>paszport</label>
										<input type="checkbox" disabled="disabled">										
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$typ-id != 'T' and $typ-id != 'P'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>											
											
										</input>
										<label>inny</label><sup>7)</sup>
										<p style="margin: 5;">
											<xsl:choose>
												<xsl:when test="$typ-id ='D'">
													Dowód osobisty
												</xsl:when>
												<xsl:when test="$typ-id ='R'">
													Personal Identyfication Number 
												</xsl:when>												
												<xsl:when test="$typ-id ='I'">
													<xsl:value-of select="$pacjent/@typ-id-nazwa" />
												</xsl:when>
											</xsl:choose>
										</p>								
								</td>
								<td colspan="3">								
									<xsl:if test="$typ-id != 'P'">
										<xsl:value-of select="$pacjent/@id-osoby"/>
									</xsl:if>
								</td>								
							</tr>
							<tr style="height: 25px;">
								<th style="width: 90%;" colspan="6">
									I.B.10 Kraj wydania dokumentu stwierdzającego tożsamość, o którym mowa w pkt I.B.8
								</th>
							</tr>
							<tr>
								<td class="left" colspan="6">
									<xsl:if test="$typ-id != 'P'">
										<xsl:value-of select="$pacjent/@typ-id-kod-kraju" />
									</xsl:if>
								</td>
							</tr>
						</table>
					</div>
								
					<div class="sekcja">
						<div class="podtytul">I.BA. UPRAWNIENIE DODATKOWE LUB INNE UPRAWNIENIE, Z KTÓREGO BĘDZIE KORZYSTAŁ PACJENT</div>
						<xsl:variable name="upraw-dod" select="$pacjent/ns:upraw-dod" />
						<xsl:variable name="upraw-dod-dok" select="$upraw-dod/ns:upraw-dod-dok" />
						<table class="rubryka">
							<tr style="height: 40px;">
								<th style="width: 15%;">
									I.BA.1 Kod tytułu uprawnienia dodatkowego<sup>8)</sup>		
								</th>
								<th style="width: 70%;">
									I.BA.2 Dane identyfikujące dokument potwierdzający uprawnienie dodatkowe<sup>9)</sup> 
								</th>
								<th style="width: 15%;">
									I.BA.3 Ciąża<sup>10)</sup>		
								</th>
							</tr>
							<tr style="height: 100px;">
								<td>
									<xsl:value-of select="$upraw-dod/@upraw-dod-kod"/>
								</td>
								<td>
									<xsl:call-template name="upraw-dod-dok">
										<xsl:with-param name="dokument" select="$upraw-dod-dok" />
									</xsl:call-template>
								</td>
								<td>
									<input type="checkbox" disabled="disabled">
										<xsl:attribute name="readonly">readonly</xsl:attribute>
										<xsl:if test="$pacjent/ns:kobieta-w-ciazy">
											<xsl:attribute name="checked">checked</xsl:attribute>
										</xsl:if>
									</input>
								</td>
							</tr>
						</table>
					</div>
					
					<xsl:variable name="wyrob-med" select="$zlecenie/ns:okreslenie-wyrob-med/ns:wyrob-med" />
					<div class="sekcja">
						<div><strong>I.C. OKREŚLENIE WYROBU MEDYCZNEGO</strong>
							<sup>11)</sup>
						</div>
						
						<table class="rubryka">
							<tr>
								<th style="width: 15%;" colspan="2">
									I.C.1 Grupa i liczba porządkowa			
								</th>
								<th style="width: 15%;" colspan="3">
									I.C.2 Umiejscowienie (nie dotyczy stomii) 								
								</th>
							</tr>
							<tr style="height: 50px">
								<td colspan="2">
									<xsl:value-of select="$wyrob-med/@kod-mz" />
								</td>
								<td class="left" colspan="3">
									<xsl:variable name="umiejscowienie" select="$wyrob-med/ns:umiejscowienie" />
									<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$umiejscowienie/@lewostronne = 'T'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>	
										</input>
										<label>lewostronne</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$umiejscowienie/@prawostronne = 'T'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>	
										</input>
										<label>prawostronne</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="not($umiejscowienie) and not($zlecenie/ns:okreslenie-wyrob-med/ns:okulary)">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>			
										</input>
										<label>nie dotyczy</label>
								</td>											
							</tr>
							<tr>
								<th style="width: 15%;" colspan="2">
									I.C.3 Liczba przetok (dotyczy stomii)		
								</th>
								<th align="center" vertical-align="top" style="width: 15%;" colspan="3">
									I.C.4 Rodzaj przetok (dotyczy stomii)									
								</th>
							</tr>							
							<tr style="height: 50px">
								<td colspan="2">
									<xsl:value-of select="$wyrob-med/ns:stomia/@stomia-liczba-przetok" />
								</td>
								<td class="left" colspan="3">
									<xsl:variable name="stomia-rodzaj" select="$wyrob-med/ns:stomia/@rodzaj" />
									<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$stomia-rodzaj = 'U'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>
										</input>
										<label>urostomia</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$stomia-rodzaj = 'K'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>	
										</input>
										<label>kolostomia</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$stomia-rodzaj = 'I'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>				
										</input>
										<label>ileostomia</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$stomia-rodzaj = 'N'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>
										</input>
										<label>nefrostomia</label>
										<input type="checkbox" disabled="disabled">
											<xsl:attribute name="readonly">readonly</xsl:attribute>
											<xsl:if test="$stomia-rodzaj = 'S'">
												<xsl:attribute name="checked">checked</xsl:attribute>
											</xsl:if>
										</input>
										<label>inna</label>
								</td>											
							</tr>
							<tr style="height: 35px;">
								<th style="width: 15%;">
									I.C.5 Kod ICD-10
								</th>
								<th style="width: 15%;">
									I.C.6 Liczba sztuk (dotyczy zleceń innych niż comiesięczne)								
								</th>
								<th style="width: 15%;">
									I.C.7 Liczba sztuk na miesiąc (dotyczy comiesięcznych zleceń)<sup>12)</sup>	
								</th>
								<th style="width: 15%;">
									I.C.8 Pierwszy miesiąc zaopatrzenia comiesięcznego (format: MM-RRRR)								
								</th>
								<th style="width: 15%;">
									I.C.9 Liczba miesięcy zaopatrzenia comiesięcznego (1– 12)									
								</th>
							</tr>
							<xsl:variable name="uzasad-zaopatrz" select="$zlecenie/ns:uzasad-zaopatrz"/>
							<xsl:variable name="zaopatrzenie-comiesieczne" select="$wyrob-med/ns:rodzaj-zaopatrzenia/ns:zaopatrzenie-comiesieczne"/>
							<tr style="height: 50px">
								<td>
									<xsl:value-of select="$uzasad-zaopatrz/@kod-icd10" />
								</td>
								<td>
									<xsl:value-of select="$wyrob-med/ns:rodzaj-zaopatrzenia/ns:zaopatrzenie-pozostale/@lb-szt" />
								</td>
								<td>
									<xsl:value-of select="$zaopatrzenie-comiesieczne/@lb-szt-na-mies" />
								</td>
								<td>
									<xsl:call-template name="dateFormatMM-YYYY">
										<xsl:with-param name="data" select="$zaopatrzenie-comiesieczne/@okres-zaop-od"/>
									</xsl:call-template>
								</td>	
								<td>
									<xsl:value-of select="$zaopatrzenie-comiesieczne/@okres-zaop-dlug" />
								</td>												
							</tr>
							<tr style="height: 20px;">
								<th style="width: 15%;" colspan="1">
									I.C.10 Nazwa wyrobu medycznego		
								</th>
								<th style="width: 35%;" colspan="2">
									I.C.11 Kryteria przyznania wyrobu medycznego<sup>13)</sup>									
								</th>
								<th style="width: 35%;" colspan="2">
									I.C.12 Dodatkowe informacje dotyczące wyrobu<sup>14)</sup>							
								</th>
							</tr>
							<tr style="height: 200px">
								<td class="left top" colspan="1">
									<xsl:value-of select="$wyrob-med/@nazwa-przedm" />
								</td>
								<td class="left top" colspan="2">
									<xsl:for-each select="$zlecenie/ns:kryterium-przyznania">											
										<p>
											<xsl:value-of select="./@kod-kryterium"/>
											<xsl:text> - </xsl:text>
											<xsl:value-of select="./@nazwa-kryterium"/>
										</p>
									</xsl:for-each>
								</td>
								<td class="left top" colspan="2">
									<xsl:value-of select="$uzasad-zaopatrz/@dod-informacje" />
								</td>										
							</tr>
							<tr style="height: 20px;">
								<th style="width: 90%;" colspan="5">
									I.C.13 Uzasadnienie medyczne przyznania większej liczby sztuk wyrobu medycznego 
									- w przypadku uprawnienia dodatkowego 47ZN, 47DN, 47ZDN		
								</th>
							</tr>
							<tr style="height: 20px;">
								<td class="left top" tyle="width: 90%;" colspan="5">
									<xsl:value-of select="$uzasad-zaopatrz/@dod-informacje-dod-upr" />
								</td>
							</tr>
						</table>
						
						<xsl:variable name="okulary" select="$zlecenie/ns:okreslenie-wyrob-med/ns:okulary" />
 						<xsl:variable name="soczewkaDP" select="$okulary/ns:soczewka[@rodzaj = 'D' and @oko = 'P']"/>
						<xsl:variable name="soczewkaDL" select="$okulary/ns:soczewka[@rodzaj = 'D' and @oko = 'L']"/>
						<xsl:variable name="soczewkaBP" select="$okulary/ns:soczewka[@rodzaj = 'B' and @oko = 'P']"/>
 						<xsl:variable name="soczewkaBL" select="$okulary/ns:soczewka[@rodzaj = 'B' and @oko = 'L']"/>
						
						<div class="podtytul">I.CA Soczewki okularowe</div>					
						<table class="tabela">
							<tr style="height: 30px;">
								<td style="width: 15%;" colspan="2">
					
								</td>
								<td style="width: 15%;">
									Sfera		
								</td>
								<td style="width: 15%;">
									Cylinder
								</td>
								<td style="width: 15%;">
									Oś		
								</td>
								<td style="width: 15%;">
									Pryzma
								</td>
								<td style="width: 35%;">			
								</td>
							</tr>
							<tr style="height: 30px;">
								<td rowspan="2">
									Do dali
								</td>
								<td>
									OP
								</td>
								<xsl:call-template name="soczewkaTemplate">
										<xsl:with-param name="soczewka" select="$soczewkaDP"/>
								</xsl:call-template>
								
								<td rowspan="4">
										<xsl:text>Odległość źrenic ...</xsl:text>
										<xsl:value-of select="$okulary/@odleglosc-zrenic" />
										<xsl:text>... mm</xsl:text>
								</td>														
							</tr>
							<tr style="height: 30px;">
								<td>
									OL
								</td>
								<xsl:call-template name="soczewkaTemplate">
										<xsl:with-param name="soczewka" select="$soczewkaDL"/>
								</xsl:call-template>											
							</tr>
							<tr style="height: 30px;">
								<td rowspan="2">
									Do bliży
								</td>
								<td>
									OP
								</td>
								<xsl:call-template name="soczewkaTemplate">
										<xsl:with-param name="soczewka" select="$soczewkaBP"/>
								</xsl:call-template>												
							</tr>
							<tr style="height: 30px;">
								<td>
									OL
								</td>
								<xsl:call-template name="soczewkaTemplate">
										<xsl:with-param name="soczewka" select="$soczewkaBL"/>
								</xsl:call-template>	
							</tr>
						</table>
						
					</div>
				
					<xsl:variable name="uzasad-skrocenia" select="$zlecenie/ns:uzasad-skrocenia-okr-uzywalnosci" />
					<div class="sekcja">
						<div><strong>I.D. DODATKOWE WSKAZANIA DO WYSTAWIENIA ZLECENIA</strong> (WYPEŁNIA OSOBA UPRAWNIONA DO WYSTAWIENIA ZLECENIA)</div>
						<table class="rubryka">					
							<tr style="height: 25px;">
								<th style="width: 17%;">
									I.D.1 Skrócenie okresu użytkowania wyrobu medycznego
								</th>
								<th>
									I.D.2 Wskazanie kryterium skrócenia okresu użytkowania wyrobu medycznego, jeżeli dotyczy<sup>15)</sup>
								</th>											
							</tr>	
							<tr style="height: 60px;">
								<td class="center top" rowspan="3">
									<input type="checkbox" style="font-size: 14px;" disabled="disabled" >
										<xsl:attribute name="readonly">readonly</xsl:attribute>
										<xsl:if test="$uzasad-skrocenia">
											<xsl:attribute name="checked">checked</xsl:attribute>
										</xsl:if>
									</input>
								</td>
								<td class="left top">
									<xsl:value-of select="$uzasad-skrocenia/@skrocenie-okr-mz"/>						
									<xsl:call-template name="slownikKryteriumSkrocenieOkresuMz">
										<xsl:with-param name="kryterium"
											select="$uzasad-skrocenia/@skrocenie-okr-mz" />
									</xsl:call-template>
								</td>
							</tr>		
							<tr style="height: 25px;">
								<th>
									I.D.3 Uzasadnienie skrócenia okresu użytkowania wyrobu medycznego, jeżeli dotyczy	
								</th>
							</tr>
							<tr style="height: 100px;">
								<td class="left top">								
									<xsl:value-of select="$uzasad-skrocenia/@uzasadnienie-medyczne"/>
								</td>
							</tr>
						</table>
					</div>
					
					<xsl:variable name="dane-dt-wystawienia" select="/ns:dokument-zpo/ns:zlecenie/ns:dane-dt-wystawienia" />
					<xsl:variable name="osoba-uprawniona" select="$dane-dt-wystawienia/ns:osoba-uprawniona"/>
					<div class="sekcja">
						<div><strong>I.E. DANE OSOBY UPRAWNIONEJ DO WYSTAWIENIA ZLECENIA</strong></div>		
						<table class="rubryka">
							<tr>
								<th style="width: 35%;">
									I.E.1 Numer prawa wykonywania zawodu<sup>16)</sup>
								</th>				
								<th style="width: 35%;">
									I.E.2 Imię (imiona) i nazwisko 
								</th>
							</tr>
							<tr style="height: 30px;">
								<td class="center">								
									<xsl:value-of select="$osoba-uprawniona/@id-zlec"/>
								</td>
								<td class="center">								
									<xsl:value-of select="$osoba-uprawniona/@imie"/>
									<xsl:text> </xsl:text>
									<xsl:value-of select="$osoba-uprawniona/@nazwisko"/>
								</td>	
							</tr>
							<tr>
								<th>
									I.E.3 Data wystawienia
								</th>
								<th>
									I.E.4 Podpis osoby uprawnionej do wystawienia zlecenia, jeżeli dotyczy
								</th>			
							</tr>	
							<tr style="height: 40px;">
								<td class="center">								
									<xsl:variable name="data-wystawienia" select="$dane-dt-wystawienia/@data-wystawienia"/>
									<xsl:call-template name="dateFormat">
										<xsl:with-param name="data" select="$data-wystawienia"/>
									</xsl:call-template>
								</td>
								<td class="center">								
									<xsl:call-template name="signature">
										<xsl:with-param name="dokument-zpo" select="/ns:dokument-zpo"/>
										<xsl:with-param name="signature-value"
											select="/ns:dokument-zpo/ns:Signature/ns:SignatureValue"/>
										<xsl:with-param name="signature-time"
											select="/ns:dokument-zpo/ns:Signature/ns:Object/ns:QualifyingProperties/ns:SignedProperties/ns:SignedSignatureProperties/ns:SigningTime"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>
					<br/>
				</div>
	
	</xsl:template>
	
	<xsl:template name="soczewkaTemplate">
		 <xsl:param name="soczewka"/>
			<td>
					<xsl:if test="$soczewka">
						<xsl:variable name="sfera" select="$soczewka/@sfera"/>
						<xsl:choose>
							<xsl:when test="$sfera">							
								<xsl:call-template name="soczewkaWartosc">
									<xsl:with-param name="value"
										select="$sfera" />
								</xsl:call-template>		
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0.0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:if>
			</td>
			<td>
					<xsl:if test="$soczewka">
						<xsl:variable name="cylinder" select="$soczewka/@cylinder"/>
						<xsl:choose>
							<xsl:when test="$cylinder">							
								<xsl:call-template name="soczewkaWartosc">
									<xsl:with-param name="value"
										select="$cylinder" />
								</xsl:call-template>		
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0.0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:if>
			</td>
			<td>
					<xsl:if test="$soczewka">
						<xsl:variable name="os" select="$soczewka/@os"/>
						<xsl:choose>
							<xsl:when test="$os">							
								<xsl:value-of select="$os"/>			
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
			</td>
			<td>
					<xsl:if test="$soczewka">
						<xsl:variable name="pryzma" select="$soczewka/@pryzma"/>
						<xsl:choose>
							<xsl:when test="$pryzma">							
								<xsl:value-of select="$pryzma"/>		
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0.0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:if>
			</td>
	</xsl:template>
	
	<xsl:template name="soczewkaWartosc">
		 <xsl:param name="value"/>
		 <xsl:if test="$value">
		 	<xsl:choose>
				<xsl:when test="$value &gt; 0">
					<xsl:text>+</xsl:text>
					<xsl:value-of select="$value"/> 		
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$value"/>
				</xsl:otherwise>
			</xsl:choose>	
		 </xsl:if> 
	</xsl:template>

</xsl:stylesheet>
