<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:ns="https://ezwm.nfz.gov.pl/xml/e-zpo/dok-zlecenia-naprawy/v2.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- wersja transformaty -->
	<xsl:variable name="wersja" select="'1.1.0'"/>
	
	<xsl:output method="html" version="5.0" encoding="UTF-8" indent="yes" doctype-public="-//W3C//DTD HTML 5.0//EN" media-type="text/html" doctype-system="about:legacy-compat"/>
	<xsl:include href="common.xslt"/>
	<xsl:template match="/ns:dokument-zpo">
		<html>
			<head>
				<xsl:call-template name="StyleWspolne"/>
			</head>
			
			<body>
				<xsl:choose>
					<xsl:when test="./@typ-dokumentu != 'E'">
						<xsl:call-template name="bladTypDokumentu" />
					</xsl:when>
					<xsl:when test="./@nr-druku != 'N.2023.1'">
						<xsl:call-template name="bladNrDruku" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="header">
							<xsl:with-param name="zlecenie" select="./ns:zlecenie" />
						</xsl:call-template>
				
						<xsl:call-template name="naprawa">
							<xsl:with-param name="zlecenie" select="./ns:zlecenie" />
						</xsl:call-template>	
					</xsl:otherwise>
				</xsl:choose>			
				<footer>
					<xsl:call-template name="footer">
						<xsl:with-param name="wersja" select="$wersja" />
					</xsl:call-template>
				</footer>	
			</body>
			
		</html>
	</xsl:template>

	<xsl:template name="naprawa">
		<xsl:param name="zlecenie" />
		
		<xsl:variable name="pacjent" select="$zlecenie/ns:pacjent" />
		<div>
		
			<div class="naglowek" style="height: 40px;">
				<strong>CZĘŚĆ I. ZLECENIE NAPRAWY </strong>
				<span style="font-size: 15px">(WYPEŁNIA I DRUKUJE ODDZIAŁ WOJEWÓDZKI NFZ)</span>
			</div>
		
			<xsl:call-template name="dane-pacjenta">
				<xsl:with-param name="pacjent" select="$pacjent" />
			</xsl:call-template>
		
			<xsl:call-template name="informacje">
				<xsl:with-param name="informacje" select="$zlecenie/ns:informacja-dla-pacjenta" />
			</xsl:call-template>
			
			<xsl:call-template name="okreslenie-wyr-med">
				<xsl:with-param name="okreslenie" select="$zlecenie/ns:okreslenie-wyrob-med" />
			</xsl:call-template>
			
		</div>
	</xsl:template>

	<xsl:template name="dane-pacjenta">
		<xsl:param name="pacjent" />
		
		<xsl:variable name="typ-id"
			select="$pacjent/@typ-id-osoby" />
		<div class="sekcja">
			<div>
				<strong>I.A. DANE PACJENTA</strong>
			</div>
			<table class="rubryka" style="height: 90px;">
				<tr>
					<th style="width: 45%;" colspan="3">
						I.A.1 Imię (imiona)
					</th>
					<th style="width: 45%;" colspan="3">
						I.A.2 Nazwisko
					</th>
				</tr>
				<tr style="height: 35px;">
					<td class="left" colspan="3">
						<xsl:value-of select="$pacjent/@imie" />
					</td>
					<td class="left" colspan="3">
						<xsl:value-of select="$pacjent/@nazwisko" />
					</td>
				</tr>
				<tr colspan="3" style="height: 25px;">
					<th style="width: 15%;">
						I.A.3 Numer PESEL
					</th>
					<th style="width: 15%;">
						I.A.4 Data urodzenia
						<sup>1)</sup>
					</th>
					<th style="width: 15%;">
						I.A.5 Płeć
						<sup>1)</sup>
					</th>
					<th style="width: 15%;">
						I.A.6 Symbol państwa, jeżeli dotyczy<sup>2)</sup>		
					</th>
					<th style="width: 35%;">
						I.A.7 Rodzaj i numer dokumentu potwierdzającego prawo do świadczeń opieki zdrowotnej, jeżeli dotyczy
						<sup>3)</sup>
					</th>
				</tr>
				<xsl:variable name="dokument"
					select="$pacjent/ns:potw-uprawnien/ns:dokument" />
				<xsl:variable name="dokument-ue"
					select="$dokument/ns:dokument-ue" />
				<tr style="height: 75px;">
					<td>
						<xsl:if test="$typ-id = 'P'">
							<xsl:value-of select="$pacjent/@id-osoby" />
						</xsl:if>
					</td>
					<td>
						<xsl:call-template name="dateFormat">
							<xsl:with-param name="data"
								select="$pacjent/@data-ur" />
						</xsl:call-template>
					</td>
					<td>
						<xsl:variable name="plec" select="$pacjent/@plec" />
						<xsl:choose>
							<xsl:when test="$plec='0'">
								nieznana
							</xsl:when>
							<xsl:when test="$plec='1'">
								mężczyzna
							</xsl:when>
							<xsl:when test="$plec='2'">
								kobieta
							</xsl:when>
							<xsl:when test="$plec='9'">
								płeć nieokreślona
							</xsl:when>
						</xsl:choose>
					</td>
					<td>
						<xsl:value-of select="$dokument-ue/@panstwo" />
					</td>
					<td>
						<xsl:value-of select="$dokument/@rodzaj" />
						<xsl:if test="$dokument/@rodzaj">
							<xsl:call-template
								name="potwPrawaDokumentRodzaj">
								<xsl:with-param name="kodDok"
									select="$dokument/@rodzaj" />
							</xsl:call-template>
						</xsl:if>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$dokument/@numer" />
					</td>
				</tr>
				<tr>
					<th style="width: 45%;" colspan="3">
						I.A.8 Dokument stwierdzający tożsamość
						<sup>1)</sup>
					</th>
					<th style="width: 45%;" colspan="3">
						I.A.9 Seria i numer
						<sup>1)</sup>
					</th>
				</tr>
				<tr style="height: 50px;">
					<td class="left" colspan="3">
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$typ-id = 'T'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
							paszport
						</input>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$typ-id != 'T' and $typ-id != 'P'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
							inny
							<sup>4)</sup>
						</input>
						<p style="margin: 5;">
							<xsl:choose>
								<xsl:when test="$typ-id ='D'">
									Dowód osobisty
								</xsl:when>
								<xsl:when test="$typ-id ='R'">
									Personal Identyfication Number
								</xsl:when>
								<xsl:when test="$typ-id ='I'">
									<xsl:value-of select="$pacjent/@typ-id-nazwa" />
								</xsl:when>
							</xsl:choose>
						</p>
					</td>
					<td colspan="3">
						<xsl:if test="$typ-id != 'P'">
							<xsl:value-of select="$pacjent/@id-osoby" />
						</xsl:if>
					</td>
				</tr>
				<tr style="height: 25px;">
					<th style="width: 90%;" colspan="6">
						I.A.10 Kraj wydania dokumentu stwierdzającego tożsamość, o którym mowa w pkt I.A.8
					</th>
				</tr>
				<tr>
					<td class="left" colspan="6">
						<xsl:if test="$typ-id != 'P'">
							<xsl:value-of select="$pacjent/@typ-id-kod-kraju" />
						</xsl:if>
					</td>
				</tr>
			</table>
			
			<xsl:call-template name="upraw-dod">
				<xsl:with-param name="upraw-dod"
					select="$pacjent/ns:upraw-dod" />
			</xsl:call-template>	
		</div>
	</xsl:template>
	
	
	<xsl:template name="upraw-dod">
		<xsl:param name="upraw-dod"/>

		<div class="podtytul">
			I.AA. UPRAWNIENIE DODATKOWE, Z KTÓREGO BĘDZIE KORZYSTAŁ PACJENT
		</div>
		<table class="rubryka">
			<tr>
				<th style="width: 30%;">
					I.AA.1 Kod tytułu uprawnienia dodatkowego
					<sup>5)</sup>
				</th>
				<th style="width: 60%;">
					I.AA.2 Dane identyfikujące dokument potwierdzający uprawnienia dodatkowe<sup>6)</sup>
				</th>
			</tr>
			<xsl:variable name="upraw-dod-dok"
				select="$upraw-dod/ns:upraw-dod-dok" />
			<tr style="height: 70px;">
				<td>
					<xsl:value-of select="$upraw-dod/@upraw-dod-kod" />
				</td>
				<td>
					<xsl:call-template name="upraw-dod-dok">
						<xsl:with-param name="dokument"
							select="$upraw-dod-dok" />
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="informacje">
		<xsl:param name="informacje" />

		<div class="sekcja">
			<div>
				<strong>I.B INFORMACJE
				</strong>
			</div>
			<div class="podtytul" style="font-weight: normal; font-size: 12px;">
				W przypadku dokonania naprawy i wykorzystania części lub całości limitu naprawy, okres użytkowania wyrobu medycznego ulega wydłużeniu proporcjonalnie do wykorzystanej 
				części limitu naprawy, z zaokrągleniem w dół do pełnego miesiąca.
			</div>
			
			<table class="rubryka">
				<tr>
					<th colspan="6">
						I.B.1 Pacjent został poinformowany o wydłużeniu okresu użytkowania naprawianego wyrobu medycznego
					</th>
				</tr>
				<tr style="height: 50px;">
					<td class="left" colspan="6">
						<element style="margin-right: 20px;">
							<input type="checkbox" style="font-size: 14px;"
								disabled="disabled">
								<xsl:attribute name="readonly">readonly</xsl:attribute>
								<xsl:if
									test="$informacje/@info-okr-uzytkowania = 'T'">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
								TAK
							</input>
						</element>
					</td>
				</tr>
			</table>
		</div>
		
	</xsl:template>

	<xsl:template name="okreslenie-wyr-med">
		<xsl:param name="okreslenie" />

		<div class="sekcja">
			<div>
				<strong>
					I.C. OKREŚLENIE WYROBU MEDYCZNEGO BĘDĄCEGO PRZEDMIOTEM NAPRAWY WRAZ Z UZASADNIENIEM
				</strong>
			</div>

			<div class="podtytul">I.C.1 Wyrób medyczny</div>

			<xsl:variable name="wyrob-med"
				select="$okreslenie/ns:wyrob-med" />
			<table class="rubryka" style="height: 90px;">
				<tr>
					<th style="width: 50%;">
						I.C.1.1 Grupa i liczba porządkowa
					</th>
					<th style="width: 50%;">
						I.C.1.2 Identyfikator zlecenia, na podstawie którego wydano wyrób medyczny będący przedmiotem naprawy
					</th>
				</tr>
				<tr style="height: 50px">
					<td>
						<xsl:value-of select="$okreslenie/@kod-mz" />
					</td>
					<td rowspan="3">
						<xsl:value-of
							select="$okreslenie/ns:jest-zlecenie/@nr-zlecenia-nfz" />
					</td>
				</tr>
				<tr>
					<th style="width: 50%;">
						I.C.1.3 Umiejscowienie
					</th>
				</tr>
				<tr>
					<td class="left">
						<xsl:variable name="umiejscowienie"
							select="$wyrob-med/ns:umiejscowienie" />
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$umiejscowienie/@lewostronne = 'T'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
							lewostronne
						</input>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="$umiejscowienie/@prawostronne = 'T'">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
							prawostronne
						</input>
						<input type="checkbox" disabled="disabled">
							<xsl:attribute name="readonly">readonly</xsl:attribute>
							<xsl:if test="not($umiejscowienie)">
								<xsl:attribute name="checked">checked</xsl:attribute>
							</xsl:if>
							nie dotyczy
						</input>
					</td>
				</tr>
				<tr>
					<th colspan="2">
						I.C.1.4 Nazwa naprawianego wyrobu medycznego, producent, model, nazwa handlowa, kod UDI<sup>7)</sup> wraz z uzasadnieniem obejmującym jednostkowe dane medyczne pacjenta
					</th>
				</tr>
				<tr style="height: 200px">
					<td colspan="2" class="left top">
						<xsl:value-of
							select="$wyrob-med/@nazwa-przedm" />
						<xsl:text>, </xsl:text>
						<xsl:value-of
							select="$wyrob-med/@wytworca" />
						<xsl:text>, </xsl:text>
						<xsl:value-of
							select="$wyrob-med/@model" />
						<xsl:text>, </xsl:text>
						<xsl:value-of
							select="$wyrob-med/@nazwa-handlowa" />
						<xsl:text>, </xsl:text>
						<xsl:value-of
							select="$wyrob-med/@nr-seryjny" />
						
						<xsl:variable name="uzasadnienie" select="$wyrob-med/@uzasadnienie-jedn-dane-med-swiadczeniobiorcy" />	
						<xsl:if test="$uzasadnienie">
							<br/>
							<xsl:text>Uzasadnienie: </xsl:text>
							<xsl:value-of
							select="$uzasadnienie" />
						</xsl:if>
					</td>
				</tr>
			</table>

		</div>
	</xsl:template>
						
</xsl:stylesheet>
